<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Web extends CI_Controller
{

    public function index()
    {
        $data                          = array();
        $data['all_featured_products'] = $this->web_model->get_all_featured_product();
        $data['all_new_products']      = $this->web_model->get_all_new_product();
        $data['i']=0;
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $data['postads']   =$this->web_model->get_postads();
        $data['productads']   =$this->web_model->get_productads();
        $data['jackets']   =$this->web_model->get_jackets();
        $data['jackets2']   =$this->web_model->get_jackets2();
        $data['jackets3']   =$this->web_model->get_jackets3();
        $data['shirts']   =$this->web_model->get_shirts();
        $data['dress_pant']   =$this->web_model->get_dress_pants();
        $data['dress_pant2']   =$this->web_model->get_dress_pants2();
        $data['dress_pant3']   =$this->web_model->get_dress_pants3();
        $data['cotton_pants']   =$this->web_model->get_cotton_pants();
        $data['shalwar_kameez']   =$this->web_model->get_shalwar_kameez();
        $data['shalwar_kameez2']   =$this->web_model->get_shalwar_kameez2();
        $data['shalwar_kameez3']   =$this->web_model->get_shalwar_kameez3();
        $data['women_dress']   =$this->web_model->get_women_dress();
        $data['lady_sandals']   =$this->web_model->get_lady_sandals();
        $data['lady_sandals2']   =$this->web_model->get_lady_sandals2();
        $data['lady_sandals3']   =$this->web_model->get_lady_sandals3();
        $data['lady_rings']   =$this->web_model->get_lady_rings();


       
        $this->load->view('index', $data);
    }
   public function productcategory($id)
    {
        $data                       = array();
        $data['cart_contents'] = $this->cart->contents();

        $data['product'] = $this->web_model->get_all_product_by_cat_name($id);
        $data['get_all_category']   = $this->web_model->get_all_category();
      
        $this->load->view('product_category', $data);
    }
    public function contact()
    {
        $data = array();
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/contact');
        $this->load->view('web/inc/footer');
    }
    public function postad()
    {
        $data = array();
        $this->load->view('ads');
        
    }
    public function insertad()
    {
        $data = array();
        $this->load->view('insertads');
    }
    public function about()
    {
        $data                  = array();
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('about', $data);
    }
      public function privacy()
    {
        $data                  = array();
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('privacy', $data);
    }
 public function cartview()
    {
        $data                  = array();
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('cartview', $data);
    }
    public function productsdetails($id)
    {
        $data['product'] = $this->web_model->get_sepacific_product($id);
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('productdetail', $data);
    }


    public function cart()
    {
        $data                  = array();
        $data['cart_contents'] = $this->cart->contents();
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/cart', $data);
        $this->load->view('web/inc/footer');
    }

    public function product()
    {
        $this->load->library('pagination');
        $config['base_url'] = base_url('web/product');
        $config['total_rows'] = $this->db->get('tbl_product')->num_rows();
        $config['per_page'] = 8;
        $config['num_links'] = 2;
        $config['full_tag_open'] = '<ul>';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = false;
        $config['last_link'] = false;
        $config['prev_link'] = '&lt; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['last_link'] = false;
        $config['next_link'] = 'Next &gt;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a>';
        $config['cur_tag_close'] = '</a></li>';
        $this->pagination->initialize($config);
        $data                    = array();
        $data['get_all_product'] = $this->web_model->get_all_product_pagi($config['per_page'], $this->uri->segment('3'));
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/product', $data);
        $this->load->view('web/inc/footer');
    }

    public function single($id)
    {
        $data                       = array();
        $data['get_single_product'] = $this->web_model->get_single_product($id);
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/single', $data);
        $this->load->view('web/inc/footer');
    }

    public function error()
    {
        $data = array();
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/error');
        $this->load->view('web/inc/footer');
    }

    public function category_post($id)
    {
        $data                    = array();
        $data['get_all_product'] = $this->web_model->get_all_product_by_cat($id);
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/product', $data);
        $this->load->view('web/inc/footer');
    }
 public function save_cart()
    {
        $data       = array();
        $product_id = $this->input->post('product_id');
        $results    = $this->web_model->get_product_by_id($product_id);

        $data['id']      = $results->product_id;
        $data['name']    = $results->product_title;
        $data['price']   = $results->product_price;
        $data['qty']     = $this->input->post('qty');
        $data['options'] = array('product_image' => $results->product_image);

        $this->cart->insert($data);
        redirect('cartview');
    }
    public function insertpads()
    {
        $data       = array();
        $data['p_title']      = $this->input->post('title');
        $data['p_shortdesc']      = $this->input->post('shortdesc');
        $data['p_longdesc']      = $this->input->post('longdesc');
        $data['p_file']      = $this->input->post('file');
        $data['p_price']      = $this->input->post('price');
        $data['p_qty']      = $this->input->post('qty');
        $data['p_category']      = $this->input->post('category');
        $data['p_brand']      = $this->input->post('brand');
        $data['p_feature']      = $this->input->post('feature');
        $data['p_status']      = $this->input->post('status');
        $result = $this->product_model->insertproductads($data);
        $this->load->view('thankyou');
    }

    public function insertads()
    {
        $data       = array();
        $data['title']      = $this->input->post('title');
        $data['description']      = $this->input->post('desc');
        $data['year']      = $this->input->post('year');
        $data['make']      = $this->input->post('make');
        $data['conditions']      = $this->input->post('contion');
        $data['price']      = $this->input->post('price');
        $data['image']      = $this->input->post('file');
        $data['location']      = $this->input->post('state');
        $data['name']      = $this->input->post('username');
        $data['phonenumber']      = $this->input->post('phonenumber');
        $data['numberstatus']      = $this->input->post('check');
        $result = $this->product_model->insertproduct($data);
        $this->load->view('thankyou');
    }


    public function update_cart()
    {
        $data          = array();
        $data['qty']   = $this->input->post('qty');
        $data['rowid'] = $this->input->post('rowid');
        $this->cart->update($data);
        redirect('cartview');
    }

    public function remove_cart()
    {

        $data = $this->input->post('rowid');
        $this->cart->remove($data);
        redirect('cartview');
    }

    public function register_success()
    {
        $customer_name = $this->session->flashdata('customer_name');
        if (!$customer_name) {
            redirect('customer/register');
        }
        $data = array();
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/register_success');
        $this->load->view('web/inc/footer');
    }

    public function user_form()
    {
        if($this->session->userdata('customer_id')){
        $data = array();
                $data['cart_contents'] = $this->cart->contents();
                $data['get_all_category']   = $this->web_model->get_all_category();

        $this->load->view('checkout',$data);
    }else{
        $data = array();
    //    $this->load->view('web/inc/header');
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('login',$data);
    }
    }

    public function registration()
    {
        $data = array();
        // $this->load->view('web/inc/header');
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('registration',$data);
        // $this->load->view('web/inc/footer');
    }

    public function login()
    {
        $data = array();
    //    $this->load->view('web/inc/header');
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('login',$data);
    //    $this->load->view('web/inc/footer');
    }

    public function customer_save()
    {
        $data                      = array();
        $data['customer_name']     = $this->input->post('customer_name');
        $data['customer_email']    = $this->input->post('customer_email');
        $data['customer_address']  = $this->input->post('customer_address');
        $data['customer_phone']    = $this->input->post('customer_phone');
        $data['customer_city']     = $this->input->post('customer_city');
        $data['customer_country']  = $this->input->post('customer_country');
        $data['customer_zipcode']  = $this->input->post('customer_zipcode');
        $data['customer_password'] = md5($this->input->post('customer_password'));


        $this->form_validation->set_rules('customer_name', 'Customer Name', 'trim|required');
        $this->form_validation->set_rules('customer_email', 'Customer Email', 'trim|required|valid_email|is_unique[tbl_customer.customer_email]');
        $this->form_validation->set_rules('customer_password', 'Customer Password', 'trim|required');
        $this->form_validation->set_rules('customer_address', 'Customer Address', 'trim|required');
        $this->form_validation->set_rules('customer_city', 'Customer City', 'trim|required');
        $this->form_validation->set_rules('customer_country', 'Customer Country', 'trim|required');
        $this->form_validation->set_rules('customer_phone', 'Customer Phone', 'trim|required');
        $this->form_validation->set_rules('customer_zipcode', 'Customer Zipcode', 'trim|required');

        if ($this->form_validation->run() == true) {
            $result = $this->web_model->save_customer_info($data);
            if ($result) {
                $this->session->set_flashdata('customer_name', $data['customer_name']);
                $this->session->set_flashdata('customer_email', $data['customer_email']);
                redirect('register/success');   ///register/success -> register_successful
            } else {
                $this->session->set_flashdata('message', 'Customer Registration Fail');
                redirect('customer/register');
            }
        } else {
            $this->session->set_flashdata('message', validation_errors());
            redirect('customer/register');
        }
    }

    public function customer_logincheck()
    {
        $data                      = array();
        $data['customer_email']    = $this->input->post('customer_email');
        $data['customer_password'] = md5($this->input->post('customer_password'));

        $this->form_validation->set_rules('customer_email', 'Customer Email', 'trim|required|valid_email');
        $this->form_validation->set_rules('customer_password', 'Customer Password', 'trim|required');
        if ($this->form_validation->run() == true) {
            
            $result = $this->web_model->get_customer_info($data);
            if ($result) {
                $this->session->set_userdata('customer_id', $result->customer_id);
                $this->session->set_userdata('customer_email', $data['customer_email']);
                redirect('checkout');
            } else {
                $this->session->set_flashdata('message', 'Customer Login Fail');
                redirect('customer/login');
            }
        } else {
            $this->session->set_flashdata('message', validation_errors());
            redirect('customer/login');
        }
    }

    public function customer_shipping_login()
    {
        $data                      = array();
        $data['customer_email']    = $this->input->post('customer_email');
        $data['customer_password'] = md5($this->input->post('customer_password'));

        $this->form_validation->set_rules('customer_email', 'Customer Email', 'trim|required|valid_email');
        $this->form_validation->set_rules('customer_password', 'Customer Password', 'trim|required');

        if ($this->form_validation->run() == true) {
            $result = $this->web_model->get_customer_info($data);
            if ($result) {
                $this->session->set_userdata('customer_id', $result->customer_id);
                $this->session->set_userdata('customer_email', $result->customer_email);
                redirect('customer/shipping');
            } else {
                $this->session->set_flashdata('messagelogin', 'Customer Login Fail');
                redirect('user_form');
            }
        } else {
            $this->session->set_flashdata('messagelogin', validation_errors());
            redirect('user_form');
        }
    }

    public function customer_shipping_register()
    {
        $data                      = array();
        $data['customer_name']     = $this->input->post('customer_name');
        $data['customer_email']    = $this->input->post('customer_email');
        $data['customer_password'] = md5($this->input->post('customer_password'));
        $data['customer_address']  = $this->input->post('customer_address');
        $data['customer_city']     = $this->input->post('customer_city');
        $data['customer_country']  = $this->input->post('customer_country');
        $data['customer_phone']    = $this->input->post('customer_phone');
        $data['customer_zipcode']  = $this->input->post('customer_zipcode');

        $this->form_validation->set_rules('customer_name', 'Customer Name', 'trim|required');
        $this->form_validation->set_rules('customer_email', 'Customer Email', 'trim|required|valid_email|is_unique[tbl_customer.customer_email]');
        $this->form_validation->set_rules('customer_password', 'Customer Password', 'trim|required');
        $this->form_validation->set_rules('customer_address', 'Customer Address', 'trim|required');
        $this->form_validation->set_rules('customer_city', 'Customer City', 'trim|required');
        $this->form_validation->set_rules('customer_country', 'Customer Country', 'trim|required');
        $this->form_validation->set_rules('customer_phone', 'Customer Phone', 'trim|required');
        $this->form_validation->set_rules('customer_zipcode', 'Customer Zipcode', 'trim|required');

        if ($this->form_validation->run() == true) {
            $result = $this->web_model->save_customer_info($data);

            if ($result) {
                $this->session->set_userdata('customer_id', $result);
                redirect('customer/shipping');
            } else {
                $this->session->set_flashdata('message', 'Customer Shipping Fail');
                redirect('user_form');
            }
        } else {
            $this->session->set_flashdata('message', validation_errors());
            redirect('user_form');
        }
    }

    public function customer_shipping()
    {
        $data = array();
        // $this->load->view('web/inc/header');
        // $this->load->view('web/pages/customer_shipping');
        // $this->load->view('web/inc/footer');
        $this->session->set_flashdata('message', 'Customer Shipping Fail');
        redirect('user_form');

    }

    public function save_shipping_address()
    {
        $data                     = array();
        $data['shipping_name']    = $this->input->post('shipping_name');
        $data['shipping_email']   = $this->input->post('shipping_email');
        $data['shipping_address'] = $this->input->post('shipping_address');
        $data['shipping_city']    = $this->input->post('shipping_city');
        $data['shipping_country'] = $this->input->post('shipping_country');
        $data['shipping_phone']   = $this->input->post('shipping_phone');
        $data['shipping_zipcode'] = $this->input->post('shipping_zipcode');

        $this->form_validation->set_rules('shipping_name', 'Shipping Name', 'trim|required');
        
        $this->form_validation->set_rules('shipping_address', 'Shipping Address', 'trim|required');
        $this->form_validation->set_rules('shipping_city', 'Shipping City', 'trim|required');
        $this->form_validation->set_rules('shipping_country', 'Shipping Country', 'trim|required');
        $this->form_validation->set_rules('shipping_phone', 'Shipping Phone', 'trim|required');
        

        if ($this->form_validation->run() == true) {
            $result = $this->web_model->save_shipping_address($data);
            $this->session->set_userdata('shipping_id', $result);
            if ($result) {
                // seve order
                $data2['payment_type'] = "Billing Address";//$this->input->post('payment');
       // $this->form_validation->set_rules('payment', 'Payment', 'trim|required');

       // if ($this->form_validation->run() == true) {
            $payment_id           = $this->web_model->save_payment_info($data2);
            $odata                = array();
            $odata['customer_id'] = $this->session->userdata('customer_id');
            $odata['shipping_id'] = $this->session->userdata('shipping_id');
            $odata['payment_id']  = $payment_id;
            $tax                  = ($this->cart->total() * 15) / 100;
            $odata['order_total'] = $tax + $this->cart->total();

            $order_id = $this->web_model->save_order_info($odata);

            $oddata1 = array();

            $myoddata = $this->cart->contents();

            foreach ($myoddata as $oddatas) {

                $oddata1['order_id']               = $order_id;
                $oddata1['product_id']             = $oddatas['id'];
                $oddata1['product_name']           = $oddatas['name'];
                $oddata1['product_price']          = $oddatas['price'];
                $oddata1['product_sales_quantity'] = $oddatas['qty'];
                $oddata1['product_image']          = $oddatas['options']['product_image'];
                $this->web_model->save_order_details_info($oddata1);
            }

                //end point

                $data                  = array();
                $data['cart_contents'] = $this->cart->contents();
                $data['get_all_category']   = $this->web_model->get_all_category();
                $this->load->view('thankyou',$data);

                // redirect('ca');
            } else {
                $this->session->set_flashdata('message', 'Customer Shipping Fail');
                redirect('user_form');
            }
        } else {
            $this->session->set_flashdata('message', validation_errors());
            redirect('user_form');
        }
    }

    public function checkout()
    {
        $data = array();
        // $this->load->view('web/inc/header');
        $data['cart_contents'] = $this->cart->contents();
        $data['get_all_category']   = $this->web_model->get_all_category();
        $this->load->view('checkout', $data);
        // $this->load->view('web/inc/footer');
    }

    public function payment()
    {
        $data = array();
        $this->load->view('web/inc/header');
        $this->load->view('web/pages/payment');
        $this->load->view('web/inc/footer');
    }

    public function save_order()
    {
        $data['payment_type'] = $this->input->post('payment');

        $this->form_validation->set_rules('payment', 'Payment', 'trim|required');

        if ($this->form_validation->run() == true) {
            $payment_id           = $this->web_model->save_payment_info($data);
            $odata                = array();
            $odata['customer_id'] = $this->session->userdata('customer_id');
            $odata['shipping_id'] = $this->session->userdata('shipping_id');
            $odata['payment_id']  = $payment_id;
            $tax                  = ($this->cart->total() * 15) / 100;
            $odata['order_total'] = $tax + $this->cart->total();

            $order_id = $this->web_model->save_order_info($odata);

            $oddata = array();

            $myoddata = $this->cart->contents();

            foreach ($myoddata as $oddatas) {

                $oddata['order_id']               = $order_id;
                $oddata['product_id']             = $oddatas['id'];
                $oddata['product_name']           = $oddatas['name'];
                $oddata['product_price']          = $oddatas['price'];
                $oddata['product_sales_quantity'] = $oddatas['qty'];
                $oddata['product_image']          = $oddatas['options']['product_image'];
                $this->web_model->save_order_details_info($oddata);
            }

            if ($payment_method == 'paypal') {

            }
            if ($payment_method == 'cashon') {

            }

            $this->cart->destroy();

            redirect('payment');
        } else {
            $this->session->set_flashdata('message', validation_errors());
            redirect('checkout');
        }
    }

    public function pdf($order_id)
    {
        $data        = array();
        $order_info  = $this->manageorder_model->order_info_by_id($order_id);
        $customer_id = $order_info->customer_id;
        $shipping_id = $order_info->shipping_id;
        $payment_id  = $order_info->payment_id;

        $data['customer_info']      = $this->manageorder_model->customer_info_by_id($customer_id);
        $data['shipping_info']      = $this->manageorder_model->shipping_info_by_id($shipping_id);
        $data['payment_info']       = $this->manageorder_model->payment_info_by_id($payment_id);
        $data['order_details_info'] = $this->manageorder_model->orderdetails_info_by_id($order_id);
        $data['order_info']         = $this->manageorder_model->order_info_by_id($order_id);

        $this->load->library('pdf');
        $this->pdf->load_view('admin/pages/pdf', $data);
        $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->render();
        $this->pdf->stream("welcome.pdf");
    }

    // public function search()
    // {

    //     $search = $this->input->get('search');

    //     if (!empty($search)) {
    //         $data                    = array();
    //         $data['get_all_product'] = $this->web_model->get_all_search_product($search);
    //         $data['search']          = $search;

    //         if ($data['get_all_product']) {
    //             $this->load->view('web/inc/header');
    //             $this->load->view('web/pages/search', $data);
    //             $this->load->view('web/inc/footer');
    //         } else {
    //             redirect('error');
    //         }
    //     } else {
    //         redirect('error');
    //     }
    // }
    public function search()
    {

        $search = $this->input->get('search');

        if (!empty($p)) {
            $data                    = array();
            $data['get_all_product'] = $this->web_model->get_all_search_product($search);
            $data['search']          = $search;
  $data['get_all_category']   = $this->web_model->get_all_category();

            if ($data['get_all_product']) {
                $this->load->view('header', $data);
                $this->load->view('web/pages/search', $data);
                $this->load->view('footer');
            } else {
 $this->load->view('header', $data);
                $this->load->view('web/pages/error', $data);
                $this->load->view('footer');            }
        } else {
$this->load->view('header', $data);
                $this->load->view('web/pages/error', $data);
                $this->load->view('footer');         }
    }

    public function logout()
    {
        $this->session->unset_userdata('customer_id');
        $this->session->unset_userdata('customer_email');
        redirect('customer/login');
    }
    public function customer_logout()
    {
        $this->session->unset_userdata('customer_id');
        $this->session->unset_userdata('customer_email');
        redirect('/');
    }

}
