<!DOCTYPE html>
<html>

<head>
    <title>Cart View</title>
    <link rel="stylesheet" href="responsive.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="canonical" href="https://getbootstrap.com/docs/5.1/examples/navbars/">

    <!-- CSS page link -->
    <link rel="stylesheet" type="text/css" href="index.css">

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">


    <!-- Bootstrap core CSS -->


    <!-- Favicons -->

    <meta name="theme-color" content="#7952b3">



    <style>
    #searchbtn:hover {
        background-color: rgb(158, 96, 216);

    }



    body {
        font-family: Arial, Helvetica, sans-serif;
    }

    .navbar {
        overflow: hidden;
        background-color: #333;
    }

    .navbar a {
        float: left;
        font-size: 16px;
        color: rgb(94, 76, 76);
        text-align: center;
        padding: 14px 16px;
        text-decoration: none;
    }
    </style>

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"
        integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"
        integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous">
    </script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"
        integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous">
    </script>


    <style>
    .container {
        row-gap: 2px;
    }
    </style>

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
    .dropbtn {
        background-color: #cc4928;
        color: white;
        padding: 16px;
        font-size: 12px;
        border: none;
    }

    .dropdown {
        position: relative;
        display: inline-block;
    }

    .dropdown-content {
        display: none;
        position: absolute;
        background-color: #f1f1f1;
        min-width: 160px;
        box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
        z-index: 1;
    }

    .dropdown-content a {
        color: black;
        padding: 12px 16px;
        text-decoration: none;
        display: block;
    }

    .dropdown-content a:hover {
        background-color: #ddd;
    }

    .dropdown:hover .dropdown-content {
        display: block;
    }




    .navbar {
        position: relative;
        min-height: 0px;
        margin-bottom: 20px;
        border: 1px solid transparent;
    }
    </style>




</head>

<body>
    <div class="b-example-divider"></div>

    <?php include'header2.php'?>

    <body class="bg-light">

        <!------container Body-->
        <div class="container bg-white">
            <div class="row">
                <h3 class="text-warning p-3">SHOPPING CART</h3>
            </div>
            <hr>
            <?php if ($this->cart->total_items()) { ?>

            <div class="row bg-light">
                <span class="bg-light "><strong> All Your Selected Products</strong></span>

            </div><br>
            <!--For PC-->
            <div class="col-12 col-md-8 col-sm-12 ">
                <div class="hiddenproductmobile">
                    <div class="row">
                        <div class="col-md-5 col-sm-5">PRODUCT</div>
                        <div class="col-md-2 col-sm-2">PRICE</div>
                        <div class="col-md-2 col-sm-2">QTY</div>
                        <div class="col-md-2 col-sm-2">SUBTOTAL</div>
                        <div class="col-md-1 col-sm-1"></div>
                        <hr>
                    </div>
                    <div class="row">
                        <?php
                        $i = 0;
                        foreach ($cart_contents as $cart_items) {
                            $i++;
                            ?>
                        <tr>
                            <div class="col-md-3 col-sm-3"><img class="img-fluid"
                                    src="<?php echo base_url('uploads/' . $cart_items['options']['product_image']) ?>">
                            </div>
                            <div class="col-md-2 col-sm-2">
                                <p><?php echo $cart_items['name'] ?></p>
                            </div>
                            <div class="col-md-2 col-sm-2">Rs.
                                <?php echo $this->cart->format_number($cart_items['price']) ?></div>
                            <div class="col-md-2 col-sm-2">
                                <form action="<?php echo base_url('update/cart'); ?>" method="post">
                                    <input type="number" class="w-100" name="qty"
                                        value="<?php echo $cart_items['qty'] ?>" />
                                    <input type="hidden" name="rowid" value="<?php echo $cart_items['rowid'] ?>" />
                                    <input type="submit" style="    background: white; border: 0px solid; color: #337ab7;" name="submit" value="edit" />
                                </form>
                            </div>
                            <div class="col-md-2 col-sm-2">Rs.
                                <?php echo $this->cart->format_number($cart_items['subtotal']) ?></div>
                            <div class="col-md-1 col-sm-1">
                                <form action="<?php echo base_url('remove/cart'); ?>" method="post">
                                    <input type="hidden" name="rowid" value="<?php echo $cart_items['rowid'] ?>" />
                                    <input class="p-2 center-block" type="submit" name="submit" value="X" />
                                </form>
                            </div>
                            <?php } ?>

                            <hr>
                    </div>
                </div>


                <!--For Mobile-->

                <div class="row hiddenproductpc">
                    <div class="col-5 p-3">
                        <img class="img-fluid" src="NewProduct/tv.jpg">
                    </div>
                    <div class="col-6 p-3">

                        <div class="row">
                            <p>55" 4K UHD SMART LED TV (55NU7100) - OFFICIAL WARRANTY</p>
                        </div>
                        <div class="row">
                            <div class="col-3">PRICE:</div>
                            <div class="col-9">PKR 226,998</div>
                        </div>
                        <div class="row">
                            <div class="col-3">QTY</div>
                            <div class="col-9"><input type="number" min="1" class="w-50"></div>
                        </div>
                        <div class="row">
                            <a class="p-2" href="#">Edit</a>
                        </div>
                    </div>
                    <div class="col-1">
                        <img class="center-block" src="icon/baseline_delete_black_24dp.png">
                    </div>


                </div>
                <div class="row">

                    <div class="col-4 col-md-4 col-sm-4"><span><a class="p-2" href="#">EMPTY CART</a></span></div>
                    <div class="col-4 col-md-4 col-sm-4"><span><a class="p-2" href="#">UPDATEED CART</a></span>
                    </div>
                    <div class="col-4 col-md-4 col-sm-4"><span><a class="p-2" href="#">CONTINUE CART</a></span>
                    </div>

                </div>
            </div>




            <div class="col-12 col-md-4 col-sm-12">
                <div class="row p-3 bg-new">
                    <div class="col-12 col-md-4 col-sm-12">DISCOUNT CODES</div>
                    <div class="col-6 col-md-6 col-sm-6"><input class="w-75" type="text"></div>
                    <div class="col-6 col-md-2 col-sm-6"><a class="p-2" href="#">APPLY</a></div>
                </div><br>
                <div class="row p-3 bg-new">
                    <div class="text-right"><span>SUBTOTAL : </span>
                        <span>Rs. <?php echo $this->cart->format_number($this->cart->total()) ?></span>
                        <hr>
                        <?php
                                $total = $this->cart->total();
                                $tax = ($total * 15) / 100;
                                echo $this->cart->format_number($tax);
                                ?>
                    </div>
                    <div class="text-right"><span>GRAND TOTAL : </span>
                        <span>Rs. <?php echo $this->cart->format_number($tax + $this->cart->total()); ?> </span>
                        <hr>
                    </div>
                    <div class="text-right">
                        <?php
                    $customer_id = $this->session->userdata('customer_id');
                        ?>
                        <a href="<?php echo base_url('user_form') ?>"><input type="button" class="bg-danger text-white"
                                onclick="location.href='stepsbuyproduct.html'" value="PROCEED TO CHECKOUT"></a>

                    </div>
                </div>
                <?php
                } else {
                    echo "<h1>Your Cart Empty</h1>";
                }
                ?>
            </div>

        </div><br>
        <hr>

        <!------Add footer------>
        <?php include'footer.php'?>



    </body>



</html>